package easik.sketch.edge;


import org.jgrapht.graph.DefaultEdge;

import easik.sketch.vertex.EntityNode;

/** 
 * This is a class to represent an arrow between two nodes. It is a directed edge
 * and has a boolean option to be injective. Every arrow has a unique identifier
 * which is referred to by constraints when stored in XML.
 *
 * @author Rob Fletcher 2005
 */
public class SketchEdge extends DefaultEdge {
	/**
	 * Stores whether this edge is injective
	 */
	private boolean _isOneToOne;
	/**
	 * Stores the name of this edge
	 */
	private String _uniqueName;
	/**
	 * The entity node that acts as this edge's source
	 */
	private EntityNode _sourceObj;
	/**
	 * The entity node that acts as this edge's target
	 */
	private EntityNode _targetObj;
		
	/**
	 * Creates a new arrow and gives it a name indicative of its source and target.
	 * @param a The source
	 * @param b The target
	 * @param unique The unique identifier
	 * @param oneone Is it injective 
	 */
	public SketchEdge(EntityNode a, EntityNode b, String unique, boolean oneone) {		
		_sourceObj = a;
		_targetObj = b;
		_uniqueName = unique;	
		_isOneToOne = oneone;	
	}
	
	/**
	 * Getter method for the source of this sketch edge
	 * @return The source of this edge, defined to be an entityNode.
	 */
	public Object getSourceObj(){
		return _sourceObj;
	}
	
	/**
	 * Getter method for the target of this sketch edge
	 * @return The target of this edge, defined to be an entityNode.
	 */
	public Object getTargetObj(){
		return _targetObj;
	}
	
	/**
	 * toString method returns the common name.
	 * @return Name of the edge
	 */
	public String toString() {
		return _uniqueName;
	}

	/**
	 * Accessor for the unique ID
	 * @return The unique ID
	 */
	public String getName() {
		return _uniqueName;
	}
	
	/**
	 * Sets the name of this edge.  
	 * @param inName The unique name of the edge.
	 */
	public void setName(String inName) {
		_uniqueName = inName;
	}
	
	/**
	 * Accessor for the injective quality
	 * @return Injectiveness of the arrow
	 */
	public boolean getInjective() {
		return _isOneToOne;
	}
}

